/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.service;

import cis.common.digsig.certificate.KeyStoreContainerType;
import cis.common.digsig.signer.service.EncryptedPassCode;
import cis.common.digsig.signer.service.PlainTextPassCode;
import cis.common.digsig.support.SigningStandard;
import cis.common.digsig.support.SigningStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class KeyStoreConfiguration {
    @Value(value="${signingStandard}")
    private String signingStandard;
    @Value(value="${signingStrategy}")
    private String signingStrategy;
    @Value(value="${configuration.keystore.containerType}")
    private String keyStoreContainerType;
    @Value(value="${configuration.keystore.location}")
    private String keyStoreLocation;
    @Value(value="${configuration.keystore.alias}")
    private String keyStoreAlias;
    @Value(value="${configuration.keystore.passcode}")
    private String keyStorePasscode;
    @Value(value="${configuration.certificate.subject}")
    private String certificateSubject;
    @Value(value="${configuration.certificate.issuer}")
    private String certificateIssuer;
    @Value(value="${configuration.certificate.serialNumber}")
    private String certificateSerialNumber;
    @Value(value="${configuration.certificate.validFrom}")
    private String certificateValidFrom;
    @Value(value="${configuration.certificate.validTo}")
    private String certificateValidTo;

    public String getKeyStoreAlias() {
        if (!StringUtils.hasText((String)this.keyStoreAlias)) {
            return null;
        }
        return this.keyStoreAlias;
    }

    public KeyStoreContainerType getKeyStoreContainerType() {
        if (!StringUtils.hasText((String)this.keyStoreContainerType)) {
            return null;
        }
        return KeyStoreContainerType.valueOf((String)this.keyStoreContainerType);
    }

    public String getKeyStorePasscode() {
        if (!StringUtils.hasText((String)this.keyStorePasscode)) {
            return null;
        }
        try {
            return EncryptedPassCode.init((String)this.keyStorePasscode).decrypt();
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Something went wrong during Decryption of password " + this.keyStorePasscode);
        }
    }

    public String getKeystoreLocation() {
        if (!StringUtils.hasText((String)this.keyStorePasscode)) {
            return null;
        }
        return this.keyStoreLocation;
    }

    public SigningStandard getSigningStandard() {
        if (!StringUtils.hasText((String)this.signingStandard)) {
            throw new RuntimeException("Signing Standard property is missing from the configuration file");
        }
        return SigningStandard.valueOf((String)this.signingStandard);
    }

    public SigningStrategy getSigningStrategy() {
        if (!StringUtils.hasText((String)this.signingStrategy)) {
            throw new RuntimeException("Signing Strategy property is missing from the configuration file");
        }
        return SigningStrategy.valueOf((String)this.signingStrategy);
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public void setKeyStorePasscode(String keyStorePasscode) {
        if (!StringUtils.hasText((String)keyStorePasscode)) {
            this.keyStorePasscode = "";
            return;
        }
        try {
            this.keyStorePasscode = PlainTextPassCode.init((String)keyStorePasscode).encrypt();
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Something went wrong during Encrypting password " + keyStorePasscode);
        }
    }

    public void setKeyStoreContainerType(String keyStoreContainerType) {
        this.keyStoreContainerType = keyStoreContainerType;
    }

    public String getCertificateIssuer() {
        return this.certificateIssuer;
    }

    public String getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public String getCertificateSubject() {
        return this.certificateSubject;
    }

    public String getCertificateValidFrom() {
        return this.certificateValidFrom;
    }

    public String getCertificateValidTo() {
        return this.certificateValidTo;
    }

    public void setCertificateIssuer(String certificateIssuer) {
        this.certificateIssuer = certificateIssuer;
    }

    public void setCertificateSerialNumber(String certificateSerialNumber) {
        this.certificateSerialNumber = certificateSerialNumber;
    }

    public void setCertificateSubject(String certificateSubject) {
        this.certificateSubject = certificateSubject;
    }

    public void setCertificateValidFrom(String certificateValidFrom) {
        this.certificateValidFrom = certificateValidFrom;
    }

    public void setCertificateValidTo(String certificateValidTo) {
        this.certificateValidTo = certificateValidTo;
    }

    public void saveApplicationProperties() {
        try {
            Properties props = new Properties();
            props.setProperty("configuration.keystore.containerType", KeyStoreConfiguration.safeNull((String)this.keyStoreContainerType));
            props.setProperty("configuration.keystore.location", KeyStoreConfiguration.safeNull((String)this.keyStoreLocation));
            props.setProperty("configuration.keystore.alias", KeyStoreConfiguration.safeNull((String)this.keyStoreAlias));
            props.setProperty("configuration.keystore.passcode", KeyStoreConfiguration.safeNull((String)this.keyStorePasscode));
            props.setProperty("configuration.certificate.subject", KeyStoreConfiguration.safeNull((String)this.certificateSubject));
            props.setProperty("configuration.certificate.issuer", KeyStoreConfiguration.safeNull((String)this.certificateIssuer));
            props.setProperty("configuration.certificate.serialNumber", KeyStoreConfiguration.safeNull((String)this.certificateSerialNumber));
            props.setProperty("configuration.certificate.validFrom", KeyStoreConfiguration.safeNull((String)this.certificateValidFrom));
            props.setProperty("configuration.certificate.validTo", KeyStoreConfiguration.safeNull((String)this.certificateValidTo));
            File f = new File("application.properties");
            FileOutputStream out = new FileOutputStream(f);
            DefaultPropertiesPersister p = new DefaultPropertiesPersister();
            p.store(props, (OutputStream)out, "KeyStore Configuration Properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String safeNull(String value) {
        return Optional.ofNullable(value).orElse("");
    }
}

